/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.util.progressbar;

import java.io.PrintStream;

import nuts.core.lang.StringUtils;

/**
 * Percent bar of console
 */
public class ConsolePercentBar extends ConsoleProgressBar {

	private int savePercent;
	
	/**
	 * constructor
	 */
	public ConsolePercentBar() {
		super();
		init();
	}

	/**
	 * constructor
	 * @param out output
	 */
	public ConsolePercentBar(PrintStream out) {
		super(out);
		init();
	}

	/**
	 * init progress
	 */
	protected void init() {
		setSize(4);
		savePercent = -1;
		space();
	}
	
	/**
	 * draw progress
	 */
	protected void draw() {
		int percent = getPercent();
		if (savePercent != percent) {
			savePercent = percent;

			clear();
			out.print(StringUtils.leftPad(String.valueOf(percent), 3) + "%");
			out.flush();
		}
	}
}
