/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.util.progressbar;

import nuts.core.util.Percent;

/**
 * AbstractProgressBar
 */
public abstract class AbstractProgressBar extends Percent implements Runnable {
	/**
	 * DEFAULT_SPEED = 50;
	 */
	public static int DEFAULT_SPEED = 50;
	
	private int speed;
	
	private boolean daemon;

	private volatile Thread thread;

	/**
	 * constructor
	 */
	public AbstractProgressBar() {
		daemon = true;
		speed = DEFAULT_SPEED;
	}

	/**
	 * @return speed
	 */
	public int getSpeed() {
		return speed;
	}

	/**
	 * 10 ....50(default).... 1000
	 * fast ................. slow
	 * @param speed speed
	 */
	public void setSpeed(int speed) {
		this.speed = speed;
	}

	/**
	 * @return the daemon
	 */
	public boolean isDaemon() {
		return daemon;
	}

	/**
	 * @param daemon the daemon to set
	 */
	public void setDaemon(boolean daemon) {
		this.daemon = daemon;
	}

	/**
	 * start
	 */
	public void start() {
		if (thread == null) {
			thread = new Thread(this);
			thread.setDaemon(daemon);
			thread.start();
		}
	}

	/**
	 * stop
	 */
	public void stop() {
		thread = null;
		draw();
	}

	/**
	 * @see java.lang.Runnable#run()
	 */
	public void run() {
		Thread thisThread = Thread.currentThread();
		while (thread == thisThread) {
			draw();
			try {
				Thread.sleep(speed);
			}
			catch (InterruptedException e) {	
			}
		}
	}

	/**
	 * draw progress
	 */
	protected abstract void draw();
}
