/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.util.converter;




public abstract class PrimitiveWrapConverter<T> extends PrimitiveTypeConverter<T> {
	public PrimitiveWrapConverter(Class<T> type) {
		super(type);
	}
	
	public static class BooleanConverter extends PrimitiveTypeConverter.BooleanConverter {
		@Override
		protected Boolean defaultValue() {
			return null;
		}
	}

	public static class ByteConverter extends PrimitiveTypeConverter.ByteConverter {
		@Override
		protected Byte defaultValue() {
			return null;
		}
	}


	public static class CharacterConverter extends PrimitiveTypeConverter.CharacterConverter {
		@Override
		protected Character defaultValue() {
			return null;
		}
	}

	public static class DoubleConverter extends PrimitiveTypeConverter.DoubleConverter {
		@Override
		protected Double defaultValue() {
			return null;
		}
	}

	public static class FloatConverter extends PrimitiveTypeConverter.FloatConverter {
		@Override
		protected Float defaultValue() {
			return null;
		}
	}

	public static class IntegerConverter extends PrimitiveTypeConverter.IntegerConverter {
		@Override
		protected Integer defaultValue() {
			return null;
		}
	}

	public static class LongConverter extends PrimitiveTypeConverter.LongConverter {
		@Override
		protected Long defaultValue() {
			return null;
		}
	}

	public static class ShortConverter extends PrimitiveTypeConverter.ShortConverter {
		@Override
		protected Short defaultValue() {
			return null;
		}
	}


}
