/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.util.converter;



public abstract class AbstractConverter<T> implements Converter<T> {
	protected Class<T> type;
	
	public AbstractConverter(Class<T> type) {
		this.type = type;
	}

	/**
	 * @return the type
	 */
	public Class<T> getType() {
		return type;
	}

	protected T createObject() {
		T coll;
		try {
			coll = type.newInstance();
		}
		catch (InstantiationException e) {
			throw new ConvertException(e);
		}
		catch (IllegalAccessException e) {
			throw new ConvertException(e);
		}
		return coll;
	}

	/**
	 * Convert value
	 * @param value value
	 * @return converted value
	 */
	@SuppressWarnings("unchecked")
	public T convert(Object value) {
		if (value == null) {
			return defaultValue();
		}

		if (isAssignable(value.getClass())) {
			return (T)value;
		}
		
		return convertValue(value);
	}
	
	protected T defaultValue() {
		return null;
	}
	
	protected boolean isAssignable(Class clazz) {
		return type.isAssignableFrom(clazz);
	}
	
	@SuppressWarnings("unchecked")
	protected T convertValue(Object value) {
		// throw CastException
		return (T)value;
	}
}
