/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.util.comparator;

import nuts.core.beans.PropertyUtils;
import nuts.core.lang.StringUtils;



/**
 * comparator for property
 */
public class PropertyComparator extends AbstractComparator<Object> {
	protected String propertyName;
	
	/**
	 * @param propertyName property name
	 */
	public PropertyComparator(String propertyName) {
		super();
		this.propertyName = propertyName;
	}

	/**
	 * @param propertyName property name
	 * @param descend descend
	 */
	public PropertyComparator(String propertyName, boolean descend) {
		super(descend);
		this.propertyName = propertyName;
	}

	/**
	 * @return the propertyName
	 */
	public String getPropertyName() {
		return propertyName;
	}

	/**
	 * @param propertyName the propertyName to set
	 */
	public void setPropertyName(String propertyName) {
		if (StringUtils.isEmpty(propertyName)) {
			throw new IllegalArgumentException("Empty propertyName!");
		}
		this.propertyName = propertyName;
	}

	/**
	 * @param o1 object1
	 * @param o2 object2
     * @return a negative integer, zero, or a positive integer as the
     * 	       first argument is less than, equal to, or greater than the
     *	       second.
	 */
	@SuppressWarnings("unchecked")
	protected int _compare(Object o1, Object o2) {
		if (o1 == null && o2 == null) {
			return 0;
		}
		if (o1 == null) {
			return -1;
		}
		if (o2 == null) {
			return 1;
		}
		if (o1 == o2) {
			return 0;
		}
		Object v1 = null;
		try {
			v1 = PropertyUtils.getSimpleProperty(o1, propertyName);
		}
		catch (Exception e) {
		}

		Object v2 = null;
		try {
			v2 = PropertyUtils.getSimpleProperty(o2, propertyName);
		}
		catch (Exception e) {
		}
		
		if (v1 == null) {
			return -1;
		}
		if (v2 == null) {
			return 1;
		}
		
		if (v1 instanceof Comparable && v1.getClass().equals(v2.getClass())) {
			return ((Comparable)v1).compareTo(v2);
		}
		else {
			return v1.toString().compareTo(v2.toString());
		}
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return getClass().getName() + "(" + propertyName + ", " + (descend ? "descend" : "") + ")@" + Integer.toHexString(hashCode());
	}
}
