/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

import nuts.core.lang.CharsetUtils;
import nuts.core.lang.StringEncodeUtils;

import org.apache.commons.codec.binary.Base64;

/**
 */
public class StringCryptoUtils {

	public static String DEFAULT_TRANSFORM = "Blowfish";

	public static String DEFAULT_KEY = "nuts";

	public static String encrypt(String text)
			throws IllegalBlockSizeException, InvalidKeyException,
			NoSuchAlgorithmException, UnsupportedEncodingException,
			BadPaddingException, NoSuchPaddingException {
		return encrypt(text, DEFAULT_KEY, DEFAULT_TRANSFORM);
	}

	public static String decrypt(String text)
			throws IllegalBlockSizeException, InvalidKeyException,
			NoSuchAlgorithmException, UnsupportedEncodingException,
			BadPaddingException, NoSuchPaddingException {

		return decrypt(text, DEFAULT_KEY, DEFAULT_TRANSFORM);
	}
	
	public static String encrypt(String text, String key)
			throws IllegalBlockSizeException, InvalidKeyException,
			NoSuchAlgorithmException, UnsupportedEncodingException,
			BadPaddingException, NoSuchPaddingException {
		return encrypt(text, key, DEFAULT_TRANSFORM);
	}

	public static String decrypt(String text, String key)
			throws IllegalBlockSizeException, InvalidKeyException,
			NoSuchAlgorithmException, UnsupportedEncodingException,
			BadPaddingException, NoSuchPaddingException {

		return decrypt(text, key, DEFAULT_TRANSFORM);
	}
	
	public static String encrypt(String text, String key, String transform)
			throws IllegalBlockSizeException, InvalidKeyException,
			NoSuchAlgorithmException, UnsupportedEncodingException,
			BadPaddingException, NoSuchPaddingException {

		SecretKeySpec sksSpec = new SecretKeySpec(key.getBytes(CharsetUtils.UTF_8),
				transform);
		Cipher cipher = Cipher.getInstance(transform);
		cipher.init(Cipher.ENCRYPT_MODE, sksSpec);
		byte[] encrypted = cipher.doFinal(text.getBytes(CharsetUtils.UTF_8));
		return StringEncodeUtils.encodeBase64(encrypted);
	}

	public static String decrypt(String text, String key, String transform)
			throws IllegalBlockSizeException, InvalidKeyException,
			NoSuchAlgorithmException, UnsupportedEncodingException,
			BadPaddingException, NoSuchPaddingException {

		SecretKeySpec sksSpec = new SecretKeySpec(key.getBytes(CharsetUtils.UTF_8),
				transform);
		Cipher cipher = Cipher.getInstance(transform);
		cipher.init(Cipher.DECRYPT_MODE, sksSpec);
		byte[] data = Base64.decodeBase64(text);
		byte[] decrypted = cipher.doFinal(data);
		return new String(decrypted, CharsetUtils.UTF_8);
	}
}
