/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.util;

import java.util.Calendar;
import java.util.Date;

import nuts.core.lang.StringUtils;



/**
 * Profiler
 */
public class Profiler {
	private String name;
	private Date start;

	/**
	 * Constructor
	 */
	public Profiler() {
		this(StringUtils.EMPTY);
	}
	
	/**
	 * @param name profile name
	 */
	public Profiler(String name) {
		this.name = name;
		start();
	}
	
	public String timespan() {
		return timespan(Calendar.getInstance().getTime());
	}
	
	protected String timespan(Date now) {
		long ms = now.getTime() - start.getTime();

		TimeSpan ts = new TimeSpan(ms);
		
		return ts.toString();
	}
	
	public String start() {
		return start("start");
	}
	
	public String start(String msg) {
		start = Calendar.getInstance().getTime();
		return name + " " + msg;
	}

	public String elapsed() {
		return elapsed("took");
	}
	
	public String elapsed(String msg) {
		return name + " " + msg + " " + timespan();
	}
	
}
