/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.sql.criterion;

import java.util.List;

/**
 */
@SuppressWarnings("serial")
public class SqlSelectParameter extends SqlQueryParameter {

	private SqlSelectClause selectClause;

	private SqlFromClause fromClause;

	/**
	 * @return selectClause
	 */
	public SqlSelectClause getSelectClause() {
		return selectClause;
	}

	/**
	 * @param selectClause the selectClause to set
	 */
	public void setSelectClause(SqlSelectClause selectClause) {
		this.selectClause = selectClause;
	}

	/**
	 * @return fromClause
	 */
	public SqlFromClause getFromClause() {
		return fromClause;
	}

	/**
	 * @param fromClause the fromClause to set
	 */
	public void setFromClause(SqlFromClause fromClause) {
		this.fromClause = fromClause;
	}

	/**
	 * constructor
	 * 
	 * @param qp QueryParameter
	 */
	public SqlSelectParameter(SqlQueryParameter qp) {
		super(qp);
		selectClause = new SqlSelectClause();
		fromClause = new SqlFromClause();
	}

	/**
	 * constructor
	 * 
	 * @param sp SelectParameter
	 */
	public SqlSelectParameter(SqlSelectParameter sp) {
		super(sp);
		this.selectClause = sp.selectClause;
		this.fromClause = sp.fromClause;
	}

	/**
	 * constructor
	 * 
	 * @param selectClause selectClause
	 */
	public SqlSelectParameter(SqlSelectClause selectClause) {
		super();
		this.selectClause = selectClause;
		this.fromClause = new SqlFromClause();
	}

	/**
	 * constructor
	 * 
	 * @param selectClause selectClause
	 * @param qp QueryParameter
	 */
	public SqlSelectParameter(SqlSelectClause selectClause, SqlQueryParameter qp) {
		super(qp);
		this.selectClause = selectClause;
		this.fromClause = new SqlFromClause();
	}

	/**
	 * constructor
	 * 
	 * @param fromClause fromClause
	 */
	public SqlSelectParameter(SqlFromClause fromClause) {
		super();
		this.selectClause = new SqlSelectClause();
		this.fromClause = fromClause;
	}

	/**
	 * constructor
	 * 
	 * @param fromClause fromClause
	 * @param qp QueryParameter
	 */
	public SqlSelectParameter(SqlFromClause fromClause, SqlQueryParameter qp) {
		super(qp);
		this.selectClause = new SqlSelectClause();
		this.fromClause = fromClause;
	}

	/**
	 * constructor
	 * 
	 * @param selectClause selectClause
	 * @param fromClause fromClause
	 */
	public SqlSelectParameter(SqlSelectClause selectClause,
			SqlFromClause fromClause) {
		super();
		this.selectClause = selectClause;
		this.fromClause = fromClause;
	}

	/**
	 * constructor
	 * 
	 * @param selectClause selectClause
	 * @param fromClause fromClause
	 * @param qp QueryParameter
	 */
	public SqlSelectParameter(SqlSelectClause selectClause,
			SqlFromClause fromClause, SqlQueryParameter qp) {
		super(qp);
		this.selectClause = selectClause;
		this.fromClause = fromClause;
	}

	/**
	 * clear
	 */
	public void clear() {
		super.clear();
		if (selectClause != null) {
			selectClause.clear();
		}
	}

	// -------------------------------------------------------------------------
	// shortcuts for ibatis
	// -------------------------------------------------------------------------
	/**
	 * @return column list
	 */
	public List<SelectColumnExpression> getSelectColumns() {
		if (selectClause == null) {
			return null;
		}
		return selectClause.getExpressions();
	}

	/**
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result
				+ ((fromClause == null) ? 0 : fromClause.hashCode());
		result = prime * result
				+ ((selectClause == null) ? 0 : selectClause.hashCode());
		return result;
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		SqlSelectParameter other = (SqlSelectParameter) obj;
		if (fromClause == null) {
			if (other.fromClause != null)
				return false;
		} else if (!fromClause.equals(other.fromClause))
			return false;
		if (selectClause == null) {
			if (other.selectClause != null)
				return false;
		} else if (!selectClause.equals(other.selectClause))
			return false;
		return true;
	}

	/**
	 * @return a string representation of the object.
	 */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();

		sb.append("{ ");
		sb.append(super.toString());
		sb.append(", ");
		sb.append("fromClause: ").append(fromClause);
		sb.append(", ");
		sb.append("selectClause: ").append(selectClause);
		sb.append(" }");

		return sb.toString();
	}

}
