/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.sql.criterion;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 */
@SuppressWarnings("serial")
public class SqlSelectClause implements Cloneable, Serializable {

	private List<SelectColumnExpression> expressions;

    /**
	 * @return expressionList
	 */
	public List<SelectColumnExpression> getExpressions() {
		return expressions;
	}

	/**
	 * @param expressions the expressions to set
	 */
	public void setExpressions(List<SelectColumnExpression> expressions) {
		this.expressions = expressions;
	}

	/**
     * constructor
     */
    public SqlSelectClause() {
    	expressions = new ArrayList<SelectColumnExpression>();
    }
    
    /**
     * clear
     */
    public void clear() {
    	expressions.clear();
    }

    /**
     * addSelectColumn
     * @param column column
     */
    public void addSelectColumn(String column) {
    	expressions.add(new SelectColumnExpression(column));
    }

    /**
     * addSelectColumn
     * @param column column
     * @param columnAlias columnAlias
     */
    public void addSelectColumn(String column, String columnAlias) {
    	expressions.add(new SelectColumnExpression(column, columnAlias));
    }

	/**
	 * Clone
	 * @throws CloneNotSupportedException if clone not supported
	 * @return Clone Object
	 */
	public Object clone() throws CloneNotSupportedException {
		return super.clone();
	}

	/**
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((expressions == null) ? 0 : expressions.hashCode());
		return result;
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SqlSelectClause other = (SqlSelectClause) obj;
		if (expressions == null) {
			if (other.expressions != null)
				return false;
		}
		else if (!expressions.equals(other.expressions))
			return false;
		return true;
	}

	/**
     * @return  a string representation of the object.
	 */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();

		sb.append("{ ");
		sb.append("expressions: [ ").append(expressions).append(" ]");
		sb.append(" }");
		
		return sb.toString();
	}

}
