/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.sql.criterion;

import java.util.List;

import nuts.core.orm.dao.SimpleQueryParameter;
import nuts.core.orm.restriction.Orders;
import nuts.core.orm.restriction.Restrictions;

/**
 */
@SuppressWarnings("serial")
public class SqlQueryParameter extends SimpleQueryParameter {
	/**
	 * Constructor
	 */
	public SqlQueryParameter() {
		super();
	}

	/**
	 * Constructor
	 * @param qp query parameter
	 */
	public SqlQueryParameter(SqlQueryParameter qp) {
		super(qp);
	}

	/**
	 * @return restrictions
	 */
	public Restrictions getRestrictions() {
		if (restrictions == null) {
			restrictions = new SqlRestrictions();
		}
		return restrictions;
	}

	/**
	 * @return restrictions
	 */
	public SqlRestrictions getSqlRestrictions() {
		return (SqlRestrictions)getRestrictions();
	}

	/**
	 * @return orders
	 */
	public Orders getOrders() {
		if (orders == null) {
			orders = new SqlOrders();
		}
		return orders;
	}

	/**
	 * @return orders
	 */
	public SqlOrders getSqlOrders() {
		return (SqlOrders)getOrders();
	}

	/**
	 * clear
	 */
	public void clear() {
		if (orders != null) {
			((SqlOrders)orders).clear();
		}
		if (restrictions != null) {
			((SqlRestrictions)restrictions).clear();
		}
		if (excludes != null) {
			excludes.clear();
		}
		start = null;
		limit = null;
	}

	//-------------------------------------------------------------------------
	// shortcut
	//-------------------------------------------------------------------------
	/**
	 * @return orderExpressions
	 */
	public List<OrderExpression> getOrderExpressions() {
		return orders == null ? null : getSqlOrders().getExpressions();
	}

	/**
	 * @return restrictionExpressions
	 */
	public List<AbstractExpression> getRestrictionExpressions() {
		return restrictions == null ? null : getSqlRestrictions().getExpressions();
	}

}
