/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.sql.criterion;

/**
 * ValueExpression
 */
@SuppressWarnings("serial")
public class CompareValueExpression extends SimpleExpression {

	protected Object compareValue;

	/**
	 * @return the compareValue
	 */
	public Object getCompareValue() {
		return compareValue;
	}

	/**
	 * @param compareValue the compareValue to set
	 */
	public void setCompareValue(Object compareValue) {
		checkCompareValue(compareValue);
		this.compareValue = compareValue;
	}
	
	/**
	 * Constructor
	 * @param column		column
	 * @param condition		condition
	 * @param value			value
	 */
	public CompareValueExpression(String column, String condition, Object value) {
		super(column, condition);
		setCompareValue(value);
	}
	
	/**
	 * checkCompareValue
	 * @param compareValue compareValue
	 */ 
	protected void checkCompareValue(Object compareValue) {
		if (compareValue == null) {
			throw new IllegalArgumentException("compareValue for [" + column + "] cannot be null");
		}
	}

	/**
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((compareValue == null) ? 0 : compareValue.hashCode());
		return result;
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		CompareValueExpression other = (CompareValueExpression) obj;
		if (compareValue == null) {
			if (other.compareValue != null)
				return false;
		}
		else if (!compareValue.equals(other.compareValue))
			return false;
		return true;
	}


	/**
     * @return  a string representation of the object.
	 */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();

		sb.append("{ ");
		sb.append(super.toString());
		sb.append(", ");
		sb.append("compareValue: ").append(compareValue);
		sb.append(" }");

		return sb.toString();
	}

}
