/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.sql;

import nuts.core.orm.restriction.Orders;
import nuts.core.orm.restriction.Restrictions;

/**
 * Constants of logic operator.
 */
public interface SqlConstants {
	/**
	 * ASC = "ASC";
	 */
	public static final String ASC = Orders.ASC;
	
	/**
	 * DESC = "DESC";
	 */
	public static final String DESC = Orders.DESC;

	/**
	 * AND = "AND";
	 */
	public static final String AND = Restrictions.AND;
	
	/**
	 * OR = "OR";
	 */
	public static final String OR = Restrictions.OR;
	
	/**
	 * OPEN_PAREN = "(";
	 */
	public static final String OPEN_PAREN = "(";
	
	/**
	 * CLOSE_PAREN = ")";
	 */
	public static final String CLOSE_PAREN = ")";
	
	/**
	 * "IS NULL";
	 */
	public static final String IS_NULL = "IS NULL";

	/**
	 * "IS NOT NULL";
	 */
	public static final String IS_NOT_NULL = "IS NOT NULL";

	/**
	 * EQUAL = "=";
	 */
	public static final String EQUAL = "=";

	/**
	 * NOT_EQUAL = "!=";
	 */
	public static final String NOT_EQUAL = "!=";
	
	/**
	 * GREAT_THAN = ">";
	 */
	public static final String GREAT_THAN = ">";

	/**
	 * GREAT_EQUAL = ">=";
	 */
	public static final String GREAT_EQUAL = ">=";

	/**
	 * LESS_THAN = "<";
	 */
	public static final String LESS_THAN = "<";

	/**
	 * LESS_EQUAL = "<=";
	 */
	public static final String LESS_EQUAL = "<=";

	/**
	 * LIKE = "LIKE";
	 */
	public static final String LIKE = "LIKE";

	/**
	 * NOT_LIKE = "NOT LIKE";
	 */
	public static final String NOT_LIKE = "NOT LIKE";

	/**
	 * IN = "IN";
	 */
	public static final String IN = "IN";

	/**
	 * NOT_IN = "NOT IN";
	 */
	public static final String NOT_IN = "NOT IN";

	/**
	 * BETWEEN = "BETWEEN";
	 */
	public static final String BETWEEN = "BETWEEN";

	/**
	 * NOT_BETWEEN = "NOT BETWEEN";
	 */
	public static final String NOT_BETWEEN = "NOT BETWEEN";
}

