/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.oxm.adapter.filters;

import java.util.HashMap;
import java.util.Map;

import nuts.core.oxm.adapter.PropertyFilter;

public class ClassPropertyFilter implements PropertyFilter {

	private Map<Class, PropertyFilter> filters;

	/**
	 * Constructor
	 */
	public ClassPropertyFilter() {
		filters = new HashMap<Class, PropertyFilter>();
	}

	public void addFilter(Class cls, PropertyFilter filter) {
		filters.put(cls, filter);
	}
	
	public void removeFilter(Class cls) {
		filters.remove(cls);
	}
	
	/**
	 * @return the filters
	 */
	public Map<Class, PropertyFilter> getFilters() {
		return filters;
	}

	/**
	 * @param filters the filters to set
	 */
	public void setFilters(Map<Class, PropertyFilter> filters) {
		this.filters = filters;
	}

	/**
	 * @param source the owner of the property
	 * @param name the name of the property
	 * @param value the value of the property
	 * @return adapter type
	 */
	public int apply(Object source, String name, Object value) {
		if (filters != null) {
			PropertyFilter filter = filters.get(source.getClass());
			if (filter != null) {
				return filter.apply(source, name, value);
			}
		}
		return ADAPTER_AUTO;
	}
}
