/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.oxm.adapter;

import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/**
 *
 */
public class SimpleTextNode extends AbstractNodeAdapter implements Node, Text {
	public SimpleTextNode() {
	}

	public SimpleTextNode(AdapterFactory rootAdapterFactory,
			NodeAdapter parent, String propertyName, Object value) {
		setContext(rootAdapterFactory, parent, propertyName, value);
	}

	protected String getStringValue() {
		return getPropertyValue().toString();
	}

	public void setData(String string) throws DOMException {
		throw new UnsupportedOperationException();
	}

	public String getData() throws DOMException {
		return getStringValue();
	}

	public int getLength() {
		return getStringValue().length();
	}

	public String getNodeName() {
		return "#text";
	}

	public short getNodeType() {
		return Node.TEXT_NODE;
	}

	public String getNodeValue() throws DOMException {
		return getStringValue();
	}

	public void appendData(String string) throws DOMException {
		throw new UnsupportedOperationException();
	}

	public void deleteData(int i, int i1) throws DOMException {
		throw new UnsupportedOperationException();
	}

	public void insertData(int i, String string) throws DOMException {
		throw new UnsupportedOperationException();
	}

	public void replaceData(int i, int i1, String string) throws DOMException {
		throw new UnsupportedOperationException();
	}

	public Text splitText(int i) throws DOMException {
		throw new UnsupportedOperationException();
	}

	public String substringData(int beginIndex, int endIndex)
			throws DOMException {
		return getStringValue().substring(beginIndex, endIndex);
	}

	// DOM level 3

	public boolean isElementContentWhitespace() {
		throw new UnsupportedOperationException();
	}

	public String getWholeText() {
		throw new UnsupportedOperationException();
	}

	public Text replaceWholeText(String string) throws DOMException {
		throw new UnsupportedOperationException();
	}
	// end DOM level 3

	public NamedNodeMap getAttributes() {
		// TODO Auto-generated method stub
		return null;
	}

}
