/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.oxm.adapter;

import java.util.List;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleNodeList implements NodeList {
	private List<Node> nodes;

	public SimpleNodeList(List<Node> nodes) {
		this.nodes = nodes;
	}

	public int getLength() {
		return nodes.size();
	}

	public Node item(int i) {
		return nodes.get(i);
	}

	public String toString() {
		StringBuilder sb = new StringBuilder("SimpleNodeList: [");
		for (int i = 0; i < getLength(); i++)
			sb.append(item(i).getNodeName()).append(',');
		sb.append("]");
		return sb.toString();
	}
}
