/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.oxm.adapter;

import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

/**
 *
 */
public class SimpleAttrNode extends AbstractNodeAdapter implements Attr {

	/**
	 * Constructors
	 */
	public SimpleAttrNode() {
	}

	public SimpleAttrNode(AdapterFactory rootAdapterFactory,
			NodeAdapter parent, String attrName, Object value) {
		setContext(rootAdapterFactory, parent, attrName, value);
	}

	protected String getStringValue() {
		return getPropertyValue().toString();
	}

	public String getNodeName() {
		return getPropertyName();
	}

	public short getNodeType() {
		return Node.ATTRIBUTE_NODE;
	}

	public String getNodeValue() throws DOMException {
		return getStringValue();
	}

	public String getName() {
		return getNodeName();
	}

	public boolean getSpecified() {
		return false;
	}

	public String getValue() {
		return getStringValue();
	}

	public void setValue(String value) throws DOMException {
		setPropertyValue(value);
	}

	public Element getOwnerElement() {
		return (Element)getParent();
	}

	public TypeInfo getSchemaTypeInfo() {
		throw new UnsupportedOperationException();
	}

	public boolean isId() {
		return "id".equals(getPropertyName());
	}

}
