/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.oxm.adapter;

import org.w3c.dom.DOMException;
import org.w3c.dom.Text;

/**
 * ProxyTextNodeAdapter is a pass-through adapter for objects which already
 * implement the Text interface.  All methods are proxied to the underlying
 * Node except getParent(), getNextSibling() and getPreviousSibling(), which
 * are implemented by the abstract adapter node to work with the parent adapter.
 */
public class ProxyTextNodeAdapter extends ProxyNodeAdapter implements Text {

    public ProxyTextNodeAdapter(AdapterFactory factory, NodeAdapter parent, Text value) {
        super(factory, parent, value);
    }

    // convenience
    Text text() {
        return (Text) getPropertyValue();
    }

    public String toString() {
        return "ProxyTextNode for: " + text();
    }

    public Text splitText(int offset) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public int getLength() {
        return text().getLength();
    }

    public void deleteData(int offset, int count) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public String getData() throws DOMException {
        return text().getData();
    }

    public String substringData(int offset, int count) throws DOMException {
        return text().substringData(offset, count);
    }

    public void replaceData(int offset, int count, String arg) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public void insertData(int offset, String arg) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public void appendData(String arg) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public void setData(String data) throws DOMException {
        throw new UnsupportedOperationException();
    }

    // DOM level 3

    public boolean isElementContentWhitespace() {
        throw new UnsupportedOperationException();
    }

    public String getWholeText() {
        throw new UnsupportedOperationException();
    }

    public Text replaceWholeText(String string) throws DOMException {
        throw new UnsupportedOperationException();
    }
}

