/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.oxm.adapter;

import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/**
 * A NamedNodeMap that wraps the Nodes returned in their proxies.
 * 
 * Note: Since maps have no guaranteed order we don't need to worry about
 * identity here as we do with "child" adapters. In that case we need to
 * preserve identity in order to support finding the next/previous siblings.
 */
public class ProxyNamedNodeMap implements NamedNodeMap {

	private NamedNodeMap nodes;
	private AdapterFactory adapterFactory;
	private NodeAdapter parent;

	public ProxyNamedNodeMap(AdapterFactory factory, NodeAdapter parent,
			NamedNodeMap nodes) {
		this.nodes = nodes;
		this.adapterFactory = factory;
		this.parent = parent;
	}

	protected Node wrap(Node node) {
		return adapterFactory.proxyNode(parent, node);
	}

	public int getLength() {
		return nodes.getLength();
	}

	public Node item(int index) {
		return wrap(nodes.item(index));
	}

	public Node getNamedItem(String name) {
		return wrap(nodes.getNamedItem(name));
	}

	public Node removeNamedItem(String name) throws DOMException {
		throw new UnsupportedOperationException();
	}

	public Node setNamedItem(Node arg) throws DOMException {
		throw new UnsupportedOperationException();
	}

	public Node setNamedItemNS(Node arg) throws DOMException {
		throw new UnsupportedOperationException();
	}

	public Node getNamedItemNS(String namespaceURI, String localName) {
		return wrap(nodes.getNamedItemNS(namespaceURI, localName));
	}

	public Node removeNamedItemNS(String namespaceURI, String localName)
			throws DOMException {
		throw new UnsupportedOperationException();
	}
}
