/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.oxm.adapter;

import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.TypeInfo;

/**
 * ProxyAttrAdapter is a pass-through adapter for objects which already
 * implement the Attr interface. All methods are proxied to the underlying Node
 * except node traversal (e.g. getParent()) related methods which are
 * implemented by the abstract adapter node to work with the parent adapter.
 */
public class ProxyAttrAdapter extends ProxyNodeAdapter implements Attr {

	public ProxyAttrAdapter(AdapterFactory factory, NodeAdapter parent,
			Attr value) {
		super(factory, parent, value);
	}

	// convenience
	protected Attr attr() {
		return (Attr)getPropertyValue();
	}

	// Proxied Attr methods

	public String getName() {
		return attr().getName();
	}

	public boolean getSpecified() {
		return attr().getSpecified();
	}

	public String getValue() {
		return attr().getValue();
	}

	public void setValue(String string) throws DOMException {
		throw new UnsupportedOperationException();
	}

	public Element getOwnerElement() {
		return (Element)getParent();
	}

	// DOM level 3

	public TypeInfo getSchemaTypeInfo() {
		throw new UnsupportedOperationException();
	}

	public boolean isId() {
		throw new UnsupportedOperationException();
	}

	// end DOM level 3

	// End Proxied Attr methods

	public String toString() {
		return "ProxyAttribute for: " + attr();
	}
}
