/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.oxm.adapter;

import org.w3c.dom.Node;

/**
 */
public interface NodeAdapter extends Node {

	/**
	 * The adapter factory that created this node.
	 */
	AdapterFactory getAdapterFactory();

	/**
	 * The adapter factory that created this node.
	 */
	void setAdapterFactory(AdapterFactory factory);

	/**
	 * The parent adapter node of this node. Note that our parent must be
	 * another adapter node, but our children may be any kind of Node.
	 */
	NodeAdapter getParent();

	/**
	 * The parent adapter node of this node. Note that our parent must be
	 * another adapter node, but our children may be any kind of Node.
	 */
	void setParent(NodeAdapter parent);

	/**
	 * The child node before the specified sibling
	 */
	Node getChildBefore(Node thisNode);

	/**
	 * The child node after the specified sibling
	 */
	Node getChildAfter(Node thisNode);

	/**
	 * The name of the Java object (property) that we are adapting
	 */
	String getPropertyName();

	/**
	 * The name of the Java object (property) that we are adapting
	 */
	void setPropertyName(String name);

	/**
	 * The Java object (property) that we are adapting
	 */
	Object getPropertyValue();

	/** The Java object (property) that we are adapting */
	void setPropertyValue(Object prop);
}
