/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.oxm.adapter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.w3c.dom.Node;

/**
 * MapEntryAdapter adapters a java.util.Map type to an XML DOM with the following
 * structure:
 * 
 * <pre>
 *  <myMap>
 *      <entry key={key}>{value}</entry>
 *      ...
 *  </myMap>
 * </pre>
 */
public class MapEntryElementAdapter extends AbstractElementAdapter {

	public MapEntryElementAdapter() {
	}

	public MapEntryElementAdapter(AdapterFactory adapterFactory, NodeAdapter parent,
			String propertyName, Map value) {
		setContext(adapterFactory, parent, propertyName, value);
	}

	protected Map.Entry entry() {
		return (Map.Entry)getPropertyValue();
	}

	protected List<Node> buildAttrAdapters() {
		Node node = getAdapterFactory().adaptAttr(this, "key", entry().getKey().toString());
		if (node == null) {
			return new ArrayList<Node>(0);
		}

		List<Node> children = new ArrayList<Node>(1);
		children.add(node);
		return children;
	}
	
	protected List<Node> buildChildAdapters() {
		Node node = getAdapterFactory().adaptNode(this, "value", entry().getValue());
		if (node == null) {
			return new ArrayList<Node>(0);
		}
		if (node instanceof StringElementAdapter) {
			List<Node> children = ((StringElementAdapter) node).getChildAdapters();
			for (Node n : children) {
				((SimpleTextNode)n).setParent(this);
			}
			return children;
		}

		List<Node> children = new ArrayList<Node>(1);
		children.add(node);
		return children;
	}
}
