/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.oxm.adapter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.w3c.dom.Node;

/**
 * MapAdapter adapters a java.util.Map type to an XML DOM with the following
 * structure:
 * 
 * <pre>
 *  <myMap>
 *      <entry key={key}>{value}</entry>
 *      ...
 *  </myMap>
 * </pre>
 */
public class MapElementAdapter extends AbstractElementAdapter {

	public MapElementAdapter() {
	}

	public MapElementAdapter(AdapterFactory adapterFactory, NodeAdapter parent,
			String propertyName, Map value) {
		setContext(adapterFactory, parent, propertyName, value);
	}

	protected Map map() {
		return (Map)getPropertyValue();
	}

	protected List<Node> buildChildAdapters() {
		List<Node> children = new ArrayList<Node>(map().entrySet().size());

		for (Object o : map().entrySet()) {
			Map.Entry entry = (Map.Entry)o;
			Node child = getAdapterFactory().adaptNode(this, "item", entry);
			if (child != null) {
				children.add(child);
			}
		}

		return children;
	}
}
