/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.oxm.adapter;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Node;

/**
 */
public class ArrayElementAdapter extends AbstractElementAdapter {

	public ArrayElementAdapter() {
	}

	public ArrayElementAdapter(AdapterFactory adapterFactory, NodeAdapter parent,
			String propertyName, Object value) {
		setContext(adapterFactory, parent, propertyName, value);
	}

	protected void addChild(List<Node> children, Object value) {
		Node child = getAdapterFactory().adaptNode(this, "item", value);

		if (child != null) {
			children.add(child);
		}
	}

	protected List<Node> buildChildAdapters() {
		List<Node> children = new ArrayList<Node>();

		Object array = getPropertyValue();
		Class cls = array.getClass().getComponentType();
		if (cls.isPrimitive()) {
			int len = Array.getLength(array);
			for (int i = 0; i < len; i++) {
				addChild(children, Array.get(array, i));
			}
		}
		else {
			Object[] values = (Object[])array;
			for (Object value : values) {
				addChild(children, value);
			}
		}

		return children;
	}
}
