/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.orm.restriction;

import nuts.core.orm.dao.QueryParameter;


/**
 */
public class ObjectRestriction<E extends QueryParameter> extends AbstractRestriction<E> {
	/**
	 * @param example example
	 * @param name name
	 */
	public ObjectRestriction(E example, String name) {
		super(example, name);
	}

	/**
	 * @param example example
	 * @param property property
	 * @param column column
	 * @param alias alias
	 */
	public ObjectRestriction(E example, String property, String column, String alias) {
		super(example, property, column, alias);
	}

	/**
	 * @return example
	 */
	public E isNull() {
		example.getRestrictions().isNull(column);
		return example;
	}

	/**
	 * @return example
	 */
	public E isNotNull() {
		example.getRestrictions().isNotNull(column);
		return example;
	}
}
