/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.orm.restriction;

import nuts.core.orm.dao.QueryParameter;


/**
 */
public abstract class AbstractRestriction<E extends QueryParameter> {
	
	protected String property;
	protected String column;
	protected String alias;

	protected E example;

	/**
	 * @param example example
	 * @param name name
	 */
	public AbstractRestriction(E example, String name) {
		this(example, name, name, name);
	}

	/**
	 * @param example example
	 * @param property property
	 * @param column column
	 * @param alias alias
	 */
	public AbstractRestriction(E example, String property, String column, String alias) {
		super();
		this.example = example;
		this.property = property;
		this.alias = alias;
		this.column = column;
	}

	/**
	 * @return example
	 */
	public E exclude() {
		example.addExclude(property);
		return example;
	}

	/**
	 * @return example
	 */
	public E include() {
		example.removeExclude(property);
		return example;
	}
}
