/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.orm.dao;


/**
 * @param <T> model type
 */
public interface ModelMetaData<T> extends ModelAccessor<T> {

	/**
	 * @return the model bean class
	 */
	Class getModelBeanClass();
	
	/**
	 * @return the model dao class
	 */
	Class getModelDAOClass();

	/**
	 * @return the model example class
	 */
	Class getModelExampleClass();
	
	/**
	 * @return the table name
	 */
	String getTableName();

	/**
	 * @return the table alias
	 */
	String getTableAlias();

	/**
	 * @return the property names
	 */
	String[] getPropertyNames();

	/**
	 * @return the field names
	 */
	String[] getFieldNames();

	/**
	 * @return the identity property name
	 */
	String getIdentityName();
	
	/**
	 * @return the primary key property names
	 */
	String[] getPrimaryKeys();
	
	/**
	 * @return the primary key column names
	 */
	String[] getPrimaryKeyColumnNames();
	
	/**
	 * @return the primary key column aliases
	 */
	String[] getPrimaryKeyColumnAliases();
	
	/**
	 * @return the foreign key constraint array
	 */
	String[][] getForeignKeyConstraints();
	
	/**
	 * @param propertyName propertyName
	 * @return true if the property is a primary key
	 */
	boolean isPrimaryKey(String propertyName);

	/**
	 * @return the unique key constraints
	 */
	String[][] getUniqueKeyConstraints();
	
	/**
	 * getPropertyName
	 * @param fieldName fieldName
	 * @return property name
	 */
	String getPropertyName(String fieldName);
	
	/**
	 * getFieldName
	 * @param propertyName propertyName
	 * @return field name
	 */
	String getFieldName(String propertyName);

	/**
	 * getColumnName
	 * @param propertyName propertyName
	 * @return column name
	 */
	String getColumnName(String propertyName);
	
	/**
	 * getColumnAlias
	 * @param propertyName propertyName
	 * @return column alias
	 */
	String getColumnAlias(String propertyName);
	
}
