/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.orm.dao;

import nuts.core.beans.PropertyHandler;

import java.util.Map;


/**
 * @param <T> data type
 */
public interface ModelAccessor<T> extends PropertyHandler<T> {
	/**
	 * create data object
	 * @return data instance 
	 */
	T createObject();

	/**
	 * set data properties values from map
	 * @param data data
	 * @param map map
	 */
	void setDataProperties(T data, Map<String, Object> map);
	
	/**
	 * get data property values map
	 * @param data data
	 * @return property values map
	 */
	Map<String, Object> getDataProperties(T data);
}
