/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.orm.dao;

import java.util.Map;

/**
 */
public interface DataAccessSession extends DataAccessExecutor {
	/**
	 * @return Data Access Client
	 */
	DataAccessClient getDataAccessClient();
	
	/**
	 * @return model meta data map
	 */
	Map<String, ModelMetaData> getMetaDataMap();
	
	/**
	 * @param name model name
	 * @return model meta data
	 */
	ModelMetaData getMetaData(String name);

	/**
	 * @param name model name
	 * @return modelDao
	 */
	ModelDAO getModelDAO(String name);
	
	/**
	 * close session
	 */
	void close();
	
	/**
	 * @return true if session is closed
	 */
	boolean isClosed();
	
	/**
	 * commit
	 * @throws DataAccessException if a data access error occurs
	 */
	void commit() throws DataAccessException;

	/**
	 * rollback
	 * @throws DataAccessException if a data access error occurs
	 */
	void rollback() throws DataAccessException;
}
