/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.orm.dao;

import java.util.Map;


/**
 */
public class DataAccessClientProxy implements DataAccessClient {
	
	private static DataAccessClient dataAccessClient;
	
	/**
	 * @return the dataAccessClient
	 */
	public static DataAccessClient getDataAccessClient() {
		return dataAccessClient;
	}

	/**
	 * @param dataAccessClient the dataAccessClient to set
	 */
	public static void setDataAccessClient(DataAccessClient dataAccessClient) {
		DataAccessClientProxy.dataAccessClient = dataAccessClient;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return dataAccessClient.getName();
	}
	
	/**
	 * @return model meta data map
	 */
	public Map<String, ModelMetaData> getMetaDataMap() {
		return dataAccessClient.getMetaDataMap();
	}
	
	/**
	 * @param name model name
	 * @return model meta data
	 */
	public ModelMetaData getMetaData(String name) {
		return dataAccessClient.getMetaData(name);
	}

	/**
	 * @param name model name
	 * @return modelDao
	 */
	public ModelDAO getModelDAO(String name, DataAccessSession session) {
		return dataAccessClient.getModelDAO(name, session);
	}

	/**
	 * @return An DataAccessSession instance.
	 */
	public DataAccessSession openSession() throws DataAccessException {
		return dataAccessClient.openSession();
	}

	/**
	 * @param autoCommit auto commit
	 * @return An DataAccessSession instance.
	 */
	public DataAccessSession openSession(boolean autoCommit) throws DataAccessException {
		return dataAccessClient.openSession(autoCommit);
	}
}
