/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.orm.dao;

import java.util.Map;

import org.apache.commons.lang.ArrayUtils;


/**
 * @param <T> model type
 */
public abstract class AbstractModelMetaData<T> implements ModelMetaData<T> {
	protected Object getPropertyItem(Map<String, Object[]> properties, String propertyName, int i) {
		Object[] objs = properties.get(propertyName);
		return objs == null ? null : objs[i];
	}
	

	public String[] getReadPropertyNames(T data) {
		return getPropertyNames();
	}

	public String[] getWritePropertyNames(T data) {
		return getPropertyNames();
	}

	public String[] getReadPropertyNames() {
		return getPropertyNames();
	}

	public String[] getWritePropertyNames() {
		return getPropertyNames();
	}

	public boolean canReadProperty(String propertyName) {
		return ArrayUtils.contains(getPropertyNames(), propertyName);
	}

	public boolean canWriteProperty(String propertyName) {
		return ArrayUtils.contains(getPropertyNames(), propertyName);
	}

	public boolean canReadProperty(T data, String propertyName) {
		return ArrayUtils.contains(getPropertyNames(), propertyName);
	}

	public boolean canWriteProperty(T data, String propertyName) {
		return ArrayUtils.contains(getPropertyNames(), propertyName);
	}

	protected RuntimeException illegalPropertyException(String propertyName) {
		return new IllegalArgumentException("Illegal property name: " + propertyName);
	}
}
