/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/**
 * utility class for array
 */
public class ArrayUtils extends org.apache.commons.lang3.ArrayUtils {
	/**
	 * swap array element
	 * @param array the array to swap
	 * @param i element index
	 * @param j element index
	 */
	public static <T> void swap(T[] array, int i, int j) {
		T t = array[i];
		array[i] = array[j];
		array[j] = t;
	}

	/**
	 * swap array element
	 * @param array the array to swap
	 * @param i element index
	 * @param j element index
	 */
	public static void swap(boolean[] array, int i, int j) {
		boolean t = array[i];
		array[i] = array[j];
		array[j] = t;
	}


	/**
	 * swap array element
	 * @param array the array to swap
	 * @param i element index
	 * @param j element index
	 */
	public static void swap(byte[] array, int i, int j) {
		byte t = array[i];
		array[i] = array[j];
		array[j] = t;
	}

	/**
	 * swap array element
	 * @param array the array to swap
	 * @param i element index
	 * @param j element index
	 */
	public static void swap(char[] array, int i, int j) {
		char t = array[i];
		array[i] = array[j];
		array[j] = t;
	}

	/**
	 * swap array element
	 * @param array the array to swap
	 * @param i element index
	 * @param j element index
	 */
	public static void swap(double[] array, int i, int j) {
		double t = array[i];
		array[i] = array[j];
		array[j] = t;
	}

	/**
	 * swap array element
	 * @param array the array to swap
	 * @param i element index
	 * @param j element index
	 */
	public static void swap(float[] array, int i, int j) {
		float t = array[i];
		array[i] = array[j];
		array[j] = t;
	}

	/**
	 * swap array element
	 * @param array the array to swap
	 * @param i element index
	 * @param j element index
	 */
	public static void swap(int[] array, int i, int j) {
		int t = array[i];
		array[i] = array[j];
		array[j] = t;
	}

	/**
	 * swap array element
	 * @param array the array to swap
	 * @param i element index
	 * @param j element index
	 */
	public static void swap(long[] array, int i, int j) {
		long t = array[i];
		array[i] = array[j];
		array[j] = t;
	}

	/**
	 * swap array element
	 * @param array the array to swap
	 * @param i element index
	 * @param j element index
	 */
	public static void swap(short[] array, int i, int j) {
		short t = array[i];
		array[i] = array[j];
		array[j] = t;
	}

	/**
	 * Remove duplicate elements from the given array.
	 * Also sorts the array, as it uses a TreeSet.
	 * @param array the sorted array
	 * @return an array without duplicates, in natural sort order
	 */
	public static Object[] removeDuplicate(Object[] array) {
		if (ArrayUtils.isEmpty(array)) {
			return array;
		}
		Set<Object> set = new TreeSet<Object>();
		for (int i = 0; i < array.length; i++) {
			set.add(array[i]);
		}
		return set.toArray((Object[])Array.newInstance(array.getClass(), set.size()));
	}


	/**
	 * Merge the given String arrays into one, with overlapping
	 * array elements only included once.
	 * <p>The order of elements in the original arrays is preserved
	 * (with the exception of overlapping elements, which are only
	 * included on their first occurence).
	 * @param array1 the first array (can be <code>null</code>)
	 * @param array2 the second array (can be <code>null</code>)
	 * @return the new array (<code>null</code> if both given arrays were <code>null</code>)
	 */
	public static String[] merge(String[] array1, String[] array2) {
		if (isEmpty(array1)) {
			return array2;
		}
		if (isEmpty(array2)) {
			return array1;
		}
		List<String> result = new ArrayList<String>();
		result.addAll(Arrays.asList(array1));
		for (int i = 0; i < array2.length; i++) {
			String str = array2[i];
			if (!result.contains(str)) {
				result.add(str);
			}
		}
		return result.toArray(new String[result.size()]);
	}

}
