/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.json.processors;

import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import nuts.core.util.Sorter;

/**
 */
public class SorterValueProcessor implements JsonValueProcessor {
	private boolean shortName = false;
	
	/**
	 * Constructor
	 */
	public SorterValueProcessor() {
	}
	
	/**
	 * Constructor
	 * @param shortName shortName
	 */
	public SorterValueProcessor(boolean shortName) {
		this.shortName = shortName;
	}

	/**
	 * @see net.sf.json.processors.JsonValueProcessor#processArrayValue(java.lang.Object, net.sf.json.JsonConfig)
	 */
	public Object processArrayValue(Object value, JsonConfig jsonConfig) {
		return value;
	}

	/**
	 * @see net.sf.json.processors.JsonValueProcessor#processObjectValue(java.lang.String, java.lang.Object, net.sf.json.JsonConfig)
	 */
	public Object processObjectValue(String key, Object value, JsonConfig jsonConfig) {
		if (value == null) {
			return JSONNull.getInstance();
		}
		
		if (!(value instanceof Sorter)) {
			throw new IllegalArgumentException();
		}

		Sorter sorter = (Sorter)value;
		
		JSONObject jo = new JSONObject();
		
		if (shortName) {
			jo.put("c", sorter.getC());
			jo.put("d", sorter.getD());
		}
		else {
			jo.put("column", sorter.getColumn());
			jo.put("direction", sorter.getDirection());
		}
		return jo;
	}
}

