/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.json.filters;

import java.util.ArrayList;
import java.util.List;

import net.sf.json.util.PropertyFilter;

/**
 * filter sepecified types when serialize to json 
 */
public class RegMatchPropertyFilter implements PropertyFilter {

	private List<String> filterNames;
	private List<String> filterTypes;
	
	/**
	 * Constructor
	 */
	public RegMatchPropertyFilter() {
	}

	/**
	 * @return the filterNames
	 */
	public List<String> getFilterNames() {
		if (filterNames == null) {
			filterNames = new ArrayList<String>();
		}
		return filterNames;
	}

	/**
	 * @param filterNames the filterNames to set
	 */
	public void setFilterNames(List<String> filterNames) {
		this.filterNames = filterNames;
	}

	/**
	 * @return the filterTypes
	 */
	public List<String> getFilterTypes() {
		if (filterTypes == null) {
			filterTypes = new ArrayList<String>();
		}
		return filterTypes;
	}

	/**
	 * @param filterTypes the filterTypes to set
	 */
	public void setFilterTypes(List<String> filterTypes) {
		this.filterTypes = filterTypes;
	}

	/**
	 * @see net.sf.json.util.PropertyFilter#apply(java.lang.Object, java.lang.String, java.lang.Object)
	 */
	public boolean apply(Object source, String name, Object value) {
		if (value == null) {
			return true;
		}
		
		if (filterNames != null) {
			for (String s : filterNames) {
				if (name.matches(s)) {
					return true;
				}
			}
		}
		
		if (filterTypes != null) {
			for (String s : filterTypes) {
				if (value.getClass().getName().matches(s)) {
					return true;
				}
			}
		}

		return false;
	}
	
}
