/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.json.filters;

import java.util.ArrayList;
import java.util.List;

import net.sf.json.util.PropertyFilter;

public class CompositePropertyFilter implements PropertyFilter {
	private List<PropertyFilter> filters = new ArrayList<PropertyFilter>();

	public CompositePropertyFilter() {
		this(null);
	}

	public CompositePropertyFilter(List<PropertyFilter> filters) {
		if (filters != null) {
			this.filters.addAll(filters);
		}
	}

	public void addPropertyFilter(PropertyFilter filter) {
		if (filter != null) {
			filters.add(filter);
		}
	}

	public boolean apply(Object source, String name, Object value) {
		for (PropertyFilter filter : filters) {
			if (filter.apply(source, name, value)) {
				return true;
			}
		}
		return false;
	}

	public void removePropertyFilter(PropertyFilter filter) {
		if (filter != null) {
			filters.remove(filter);
		}
	}
}
