/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */

package nuts.core.json.filters;

import net.sf.json.util.PropertyFilter;

public class AndPropertyFilter implements PropertyFilter {
	private PropertyFilter filter1;
	private PropertyFilter filter2;

	public AndPropertyFilter(PropertyFilter filter1, PropertyFilter filter2) {
		this.filter1 = filter1;
		this.filter2 = filter2;
	}

	public boolean apply(Object source, String name, Object value) {
		if (filter1 != null && filter1.apply(source, name, value) && filter2 != null
				&& filter2.apply(source, name, value)) {
			return true;
		}
		return false;
	}
}