/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.i18n;

import nuts.core.lang.CharUtils;

/**
 * utility class for Asia character
 *
 */
public class AsiaCharUtils extends CharUtils {
	/**
	 * isHankakuKatakanaChar
	 * @param c char
	 * @return true if the char is Hankaku Katakana
	 */
	public static boolean isHankakuKatakanaChar(char c) {
		return c >= '\uFF61' && c <= '\uFF9F';
	}

	/**
	 * isZenkakuKatakanaChar
	 * @param c char
	 * @return true if the char is Zenkaku Katakana
	 */
	public static boolean isZenkakuKatakanaChar(char c) {
		return (c >= '\u30A1' && c <= '\u30df')
				|| (c >= '\u30E0' && c <= '\u30F6');
	}

	/**
	 * isHankakuChar
	 * @param c char
	 * @return true if the char is Hankaku
	 */
	public static boolean isHankakuChar(char c) {
		if (c <= '\377') {
			switch (c) {
			case '\247':
			case '\250':
			case '\260':
			case '\261':
			case '\264':
			case '\266':
			case '\327':
			case '\367':
				return false;
			default:
				return true;
			}
		}

		return isHankakuKatakanaChar(c);
	}

	/**
	 * isZenkakuChar
	 * @param c char
	 * @return true if the char is Zenkaku
	 */
	public static boolean isZenkakuChar(char c) {
		return !isHankakuChar(c);
	}
}
