/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.collections;

import java.util.Locale;
import java.util.TimeZone;

/**
 * MessageFormatKey
 */
public class MessageFormatKey {
	private String pattern;
	private Locale locale;
	private TimeZone timezone;

	/**
	 * Constructor
	 * 
	 * @param pattern pattern
	 * @param locale locale
	 * @param timezone timezone
	 */
	public MessageFormatKey(String pattern, Locale locale, TimeZone timezone) {
		this.pattern = pattern;
		this.locale = locale;
		this.timezone = timezone;
	}

	/**
	 * Constructor
	 * 
	 * @param pattern pattern
	 * @param locale locale
	 */
	public MessageFormatKey(String pattern, Locale locale) {
		this(pattern, locale, null);
	}

	/**
	 * @param o compare object
	 */
	@Override
	public boolean equals(Object o) {
		if (this == o)
			return true;
		if (!(o instanceof MessageFormatKey))
			return false;

		final MessageFormatKey messageFormatKey = (MessageFormatKey) o;

		if (locale != null ? !locale.equals(messageFormatKey.locale)
				: messageFormatKey.locale != null)
			return false;
		if (pattern != null ? !pattern.equals(messageFormatKey.pattern)
				: messageFormatKey.pattern != null)
			return false;
		if (timezone != null ? !timezone.equals(messageFormatKey.timezone)
				: messageFormatKey.timezone != null)
			return false;

		return true;
	}

	/**
	 * @return hash code
	 */
	@Override
	public int hashCode() {
		int result;
		result = (pattern != null ? pattern.hashCode() : 0);
		result = 29 * result + (locale != null ? locale.hashCode() : 0);
		result = 29 * result + (timezone != null ? timezone.hashCode() : 0);
		return result;
	}

	/**
	 * @return the pattern
	 */
	public String getPattern() {
		return pattern;
	}

	/**
	 * @param pattern the pattern to set
	 */
	public void setPattern(String pattern) {
		this.pattern = pattern;
	}

	/**
	 * @return the locale
	 */
	public Locale getLocale() {
		return locale;
	}

	/**
	 * @param locale the locale to set
	 */
	public void setLocale(Locale locale) {
		this.locale = locale;
	}

	/**
	 * @return the timezone
	 */
	public TimeZone getTimezone() {
		return timezone;
	}

	/**
	 * @param timezone the timezone to set
	 */
	public void setTimezone(TimeZone timezone) {
		this.timezone = timezone;
	}
	
}
