/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.beans;

/**
 * BeanHandler
 */
public interface BeanHandler<T> extends PropertyHandler<T> {
	/**
	 * create bean object
	 * @return bean instance 
	 */
	T createObject();

	/**
	 * get bean type
	 * @param beanName bean name
	 * @return bean type
	 */
	Class getBeanType(String beanName);

	/**
	 * get bean type
	 * @param beanObject bean object (can be null)
	 * @param beanName bean name
	 * @return bean type
	 */
	Class getBeanType(T beanObject, String beanName);

	/**
	 * is the bean readable
	 * @param beanName bean name
	 * @return true if bean is readable
	 */
	boolean canReadBean(String beanName);

	/**
	 * is the bean readable
	 * @param beanObject bean object (can be null)
	 * @param beanName bean name
	 * @return true if bean is readable
	 */
	boolean canReadBean(T beanObject, String beanName);
	
	/**
	 * is the bean writable
	 * @param beanName bean name
	 * @return true if bean is writable
	 */
	boolean canWriteBean(String beanName);
	
	/**
	 * is the bean writable
	 * @param beanObject bean object (can be null)
	 * @param beanName bean name
	 * @return true if bean is writable
	 */
	boolean canWriteBean(T beanObject, String beanName);
	
	/**
	 * get bean value 
	 * @param beanObject bean object
	 * @param beanName bean name
	 * @return bean value
	 */
	Object getBeanValue(T beanObject, String beanName);
	
	/**
	 * set bean value 
	 * @param beanObject bean object
	 * @param beanName bean name
	 * @param value value
	 */
	void setBeanValue(T beanObject, String beanName, Object value);

}
