/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.beans;

/**
 * AbstractSimpleBeanHandler
 */
public abstract class AbstractSimpleBeanHandler<T> implements BeanHandler<T> {
	/**
	 * get bean type
	 * @param beanName bean name
	 * @return bean type
	 */
	public Class getBeanType(String beanName) {
		return getPropertyType(beanName);
	}

	/**
	 * get bean type
	 * @param beanObject bean object (can be null)
	 * @param beanName bean name
	 * @return bean type
	 */
	public Class getBeanType(T beanObject, String beanName) {
		return getPropertyType(beanObject, beanName);
	}

	/**
	 * is the bean readable
	 * @param beanName bean name
	 * @return true if bean is readable
	 */
	public boolean canReadBean(String beanName) {
		return canReadProperty(beanName);
	}

	/**
	 * is the bean readable
	 * @param beanObject bean object (can be null)
	 * @param beanName bean name
	 * @return true if bean is readable
	 */
	public boolean canReadBean(T beanObject, String beanName) {
		return canReadProperty(beanObject, beanName);
	}
	
	/**
	 * is the property writable
	 * @param beanName bean name
	 * @return true if bean is writable
	 */
	public boolean canWriteBean(String beanName) {
		return canWriteProperty(beanName);
	}
	
	/**
	 * is the property writable
	 * @param beanObject bean object (can be null)
	 * @param beanName bean name
	 * @return true if bean is writable
	 */
	public boolean canWriteBean(T beanObject, String beanName) {
		return canWriteProperty(beanObject, beanName);
	}
	
	/**
	 * get property value 
	 * @param beanObject bean object
	 * @param beanName bean name
	 * @return bean value
	 */
	public Object getBeanValue(T beanObject, String beanName) {
		return getPropertyValue(beanObject, beanName);
	}
	
	/**
	 * set bean value 
	 * @param beanObject bean object
	 * @param beanName bean name
	 * @param value value
	 */
	public void setBeanValue(T beanObject, String beanName, Object value) {
		setPropertyValue(beanObject, beanName, value);
	}
}
