/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.algorithm.sort;

import java.util.List;


/**
 */
public class BubbleSorter extends Sorter {
	public <T extends Comparable<T>> void sort(List<T> list, int from, int to) {
		boolean change = true;
		for (int i = to - 1; i >= from + 1 && change; i--) {
			change = false;
			for (int j = from; j < i; j++) {
				if (compare(list, j, j + 1) > 0) {
					swap(list, j, j + 1);
					change = true;
				}
			}
		}
	}
}
