<#--
/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title><@n.text name="title-page"/></title>
</head>

<body>

<div class="n-sect" id="a_register_input">
	<div class="n-sect-head">
		<h3 class="n-sect-title"><@n.text name="title-input"/></h3>
	</div>
	<div class="n-sect-body">
		<#include "/nuts/exts/struts2/views/action-prompt.ftl"/>
		
		<br/>
		<div class="caption"><@n.text name="caption-register"/></div>
		<div><@n.text name="text-register"/></div>
		<br/>
		
		<@n.form action="register_insert" method="post" cssClass="n-eform" theme="nxhtml">
			<@n.hidden name="redirect"/>
			<@n.textfield key="d.name" size="40" maxlength="32" required="true">
				<@s.param name="tooltip" value="%{getText('d.name-tip', '')}"/>
			</@n.textfield>
			<@n.textfield key="d.email" size="40" maxlength="80" required="true">
				<@s.param name="tooltip" value="%{getText('d.email-tip', '')}"/>
			</@n.textfield>
			<@n.textfield key="confirmEmail" size="40" maxlength="80" required="true">
				<@s.param name="tooltip" value="%{getText('confirmEmail-tip', '')}"/>
			</@n.textfield>
			<@n.password key="d.password" showPassword="true" size="20" maxlength="12" required="true">
				<@s.param name="tooltip" value="%{getText('d.password-tip', '')}"/>
			</@n.password>
			<@n.password key="confirmPassword" showPassword="true" size="20" maxlength="12" required="true">
				<@s.param name="tooltip" value="%{getText('confirmPassword-tip', '')}"/>
			</@n.password>
			<@n.submit icon="n-icon-bullet_go"><@n.text name="button-register"/></@n.submit>
		</@n.form>
	</div>
</div>

</body>
</html>
