<#--
/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<#if Session?? && Session.user??>
<#assign _an_ = utils.actionName!/>
<#macro menu ap ac tx>
	<#if action.hasPermission("/admin", ac)>
				<li<#if __namespace?starts_with("/admin") && _an_?starts_with(ap)> class="active"</#if>><#rt/>
<@n.a action=ac namespace="/admin"><@n.text name=tx/></@n.a></li>
	</#if>
</#macro>

<div id="menu" class="n-sect">
	<div class="n-sect-head">
		<em class="n-sect-icon n-icon n-icon-wrench"></em>
		<h3 class="n-sect-title"><@n.text name="menu-admin"/></h3>
	</div>
	<div class="n-sect-body">
		<ul class="menu">
			<@menu ap="user_" ac="user_list" tx="menu-admin-user"/>
			<@menu ap="usergroup_" ac="usergroup_list" tx="menu-admin-usergroup"/>
		</ul>
		<div class="hr"></div>
		<ul class="menu">
			<@menu ap="cronjobs" ac="cronjobs" tx="menu-admin-cronjobs"/>
			<@menu ap="dataimp" ac="dataimp" tx="menu-admin-dataimp"/>
			<@menu ap="ognleval" ac="ognleval" tx="menu-admin-ognleval"/>
		<#if utils.gaeSupport>
			<@menu ap="ndfsfile_" ac="ndfsfile_list" tx="menu-admin-ndfsfile"/>
		<#else>
			<@menu ap="pdf" ac="html2pdf" tx="menu-admin-html2pdf"/>
			<@menu ap="sqlexec" ac="sqlexec" tx="menu-admin-sqlexec"/>
		</#if>
		</ul>
	</div>
</div>
</#if>
