/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.aws.dao;

import nuts.core.orm.dao.AbstractModelMetaData;

/**
 */
public abstract class AwsModelMetaData<T> extends AbstractModelMetaData<T> {
	/**
	 * getPropertyName
	 * @param fieldName fieldName
	 * @return property name
	 */
	public String getPropertyName(String fieldName) {
		return fieldName;
	}

	/**
	 * getFieldName
	 * @param propertyName propertyName
	 * @return field name
	 */
	public String getFieldName(String propertyName) {
		return propertyName;
	}

	/**
	 * getColumnName
	 * @param propertyName propertyName
	 * @return column name
	 */
	public String getColumnName(String propertyName) {
		return propertyName;
	}

	/**
	 * getColumnAlias
	 * @param propertyName propertyName
	 * @return column alias
	 */
	public String getColumnAlias(String propertyName) {
		return propertyName;
	}
}
