/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.aws.dao;

import java.util.Properties;

import nuts.core.orm.dao.AbstractDataAccessClient;
import nuts.core.orm.dao.DataAccessSession;

import com.amazonaws.services.simpledb.AmazonSimpleDB;

/**
 */
public class AwsDataAccessClient extends AbstractDataAccessClient implements AwsSimpleDBAware {
	
	private AmazonSimpleDB simpleDB;
	
	/**
	 */
	public AwsDataAccessClient() {
		super();
	}

	/**
	 * @param simpleDB the simpleDB to set
	 */
	public AwsDataAccessClient(AmazonSimpleDB simpleDB, Properties props) {
		super(props);
		this.simpleDB = simpleDB;
	}

	/**
	 * @return the simpleDB
	 */
	public AmazonSimpleDB getAmazonSimpleDB() {
		return simpleDB;
	}

	/**
	 * @param simpleDB the simpleDB to set
	 */
	public void setAmazonSimpleDB(AmazonSimpleDB simpleDB) {
		this.simpleDB = simpleDB;
	}

	/**
	 * open session
	 * @return DataAccessSession
	 */
	public DataAccessSession openSession(boolean autoCommit) {
		return new AwsDataAccessSession(this, simpleDB, autoCommit);
	}

}
