/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.aems.model.bean;

import java.io.Serializable;
import java.util.Date;

/**
 * CommonBean
 */
@SuppressWarnings("serial")
public abstract class CommonBean implements Serializable, Cloneable {

	/**
	 * @return the invalid
	 */
	public Boolean getInvalid() {
		return false;
	}

	/**
	 * @param invalid the invalid to set
	 */
	public void setInvalid(Boolean invalid) {
	}

	/**
	 * @return the cusid
	 */
	public Long getCusid() {
		return null;
	}

	/**
	 * @param cusid the cusid to set
	 */
	public void setCusid(Long cusid) {
	}

	/**
	 * @return the cusnm
	 */
	public String getCusnm() {
		return null;
	}

	/**
	 * @param cusnm the cusnm to set
	 */
	public void setCusnm(String cusnm) {
	}

	/**
	 * @return the ctime
	 */
	public Date getCtime() {
		return null;
	}

	/**
	 * @param ctime the ctime to set
	 */
	public void setCtime(Date ctime) {
	}

	/**
	 * @return the uusid
	 */
	public Long getUusid() {
		return null;
	}

	/**
	 * @param uusid the uusid to set
	 */
	public void setUusid(Long uusid) {
	}

	/**
	 * @return the uusnm
	 */
	public String getUusnm() {
		return null;
	}

	/**
	 * @param uusnm the uusnm to set
	 */
	public void setUusnm(String uusnm) {
	}

	/**
	 * @return the utime
	 */
	public Date getUtime() {
		return null;
	}

	/**
	 * @param utime the utime to set
	 */
	public void setUtime(Date utime) {
	}

	/**
	 * beInvalid
	 * @return true if invalid is true
	 */
	public Boolean beInvalid() {
		return Boolean.TRUE.equals(getInvalid());
	}

	/**
	 * beUpdated
	 * @param model model
	 * @return true if abs(this.utime - model.utime) > 1s
	 */
	public Boolean beUpdated(CommonBean model) {
		if (getUusid() == null 
				|| getUtime() == null 
				|| model.getUusid() == null 
				|| model.getUtime() == null) {
			return false;
		}
		
		if (!getUusid().equals(model.getUusid())) {
			return true;
		}

		return Math.abs(getUtime().getTime() - model.getUtime().getTime()) >= 1000;
	}
}

