/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.aems.action.user;

import java.util.Calendar;

import nuts.aems.action.AbstractAction;
import nuts.aems.constant.RC;
import nuts.aems.model.bean.User;
import nuts.aems.model.dao.UserDAO;




/**
 * PasswordChangeAction
 */
public class PasswordChangeAction extends AbstractAction {

	private String oldPassword;
    private String newPassword;
    private String confirmPassword;

	/**
	 * @return the confirmPassword
	 */
	public String getConfirmPassword() {
		return confirmPassword;
	}

	/**
	 * @param confirmPassword the confirmPassword to set
	 */
	public void setConfirmPassword(String confirmPassword) {
		this.confirmPassword = confirmPassword;
	}

	/**
	 * @return the newPassword
	 */
	public String getNewPassword() {
		return newPassword;
	}

	/**
	 * @param newPassword the newPassword to set
	 */
	public void setNewPassword(String newPassword) {
		this.newPassword = newPassword;
	}

	/**
	 * @return the oldPassword
	 */
	public String getOldPassword() {
		return oldPassword;
	}

	/**
	 * @param oldPassword the oldPassword to set
	 */
	public void setOldPassword(String oldPassword) {
		this.oldPassword = oldPassword;
	}

	/**
	 * change
	 * @return result name
	 * @throws Exception if an error occurs
	 */
    public String change() throws Exception {
    	UserDAO dao = new UserDAO(getDataAccessSession());
    	User lu = utils().getLoginUser();
    	User nu = new User();
    	
    	nu.setPassword(newPassword);
    	nu.setId(lu.getId());
    	nu.setUusid(lu.getId());
    	nu.setUtime(Calendar.getInstance().getTime());

    	dao.updateByPrimaryKeySelective(nu);
		getDataAccessSession().commit();

    	lu.setPassword(nu.getPassword());
    	lu.setUusid(nu.getUusid());
    	lu.setUtime(nu.getUtime());

    	addActionMessage(getText(RC.MESSAGE_SUCCESS));
    	
        return SUCCESS;
    }

}