/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.aems.util;

import java.io.File;

import nuts.aems.BaseApplet;

/**
 */
public abstract class AppletHelper {
	public synchronized static BaseApplet init(Class<? extends BaseApplet> clazz) {
		return init(clazz, "web");
	}
	
	public synchronized static BaseApplet init(Class<? extends BaseApplet> clazz, boolean initStruts) {
		return init(clazz, "web", initStruts);
	}
	
	public synchronized static BaseApplet init(Class<? extends BaseApplet> clazz, String contextRoot) {
		return init(clazz, contextRoot, true);
	}
	
	public synchronized static BaseApplet init(Class<? extends BaseApplet> clazz, String contextRoot, boolean initStruts) {
		if (BaseApplet.get() == null) {
			// use nsimple data source
			System.setProperty("data.source", "NSIMPLE");

			File root = new File(contextRoot);
			if (!root.exists()) {
				root = new File(".");
			}
			
			BaseApplet app;
			try {
				app = clazz.newInstance();
			}
			catch (Exception e) {
				throw new RuntimeException(e);
			}
			
			app.initialize(root.getPath(), initStruts);
		}
		return BaseApplet.get();
	}
}
