/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.aems.interceptor;

import javax.servlet.http.HttpServletRequest;

import nuts.core.net.NetUtils;
import nuts.exts.struts2.util.StrutsContextUtils;
import nuts.exts.xwork2.ActionSupport;

import com.opensymphony.xwork2.ActionInvocation;

/**
 * 
 */
@SuppressWarnings("serial")
public class TaskAuthenticationInterceptor extends UserAuthenticationInterceptor {
	
	/**
	 * 
	 */
	public TaskAuthenticationInterceptor() {
		setLoginResult(ActionSupport.XML);
		setSecureResult(ActionSupport.XML);
	}

	/**
	 * Allows the Interceptor to do some processing on the request before and/or after the rest of the processing of the
	 * request by the {@link ActionInvocation} or to short-circuit the processing and just return a String return code.
	 *
	 * @param actionInvocation  the action invocation
	 * @return the return code, either returned from {@link ActionInvocation#invoke()}, or from the interceptor itself.
	 * @throws Exception any system-level error, as defined in {@link com.opensymphony.xwork2.Action#execute()}.
	 */
	public String intercept(ActionInvocation actionInvocation) throws Exception {
		HttpServletRequest req = StrutsContextUtils.getServletRequest();
		if (NetUtils.isIntranetHost(req.getRemoteAddr())) {
			return actionInvocation.invoke();
		}
		
		return super.intercept(actionInvocation);
	}
}
