/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.aems.action.tools;

import java.util.ArrayList;
import java.util.List;

import nuts.aems.WebApplet;
import nuts.aems.action.AbstractAction;


/**
 */
public class MemCacheAction extends AbstractAction {
	protected final static String CKEY_RESOURCE = "resource";
	
	protected final static String CKEY_TEMPLATE = "template";
	
	/**
	 * Constructor
	 */
	public MemCacheAction() {
		super();
	}

	/**
	 * @return cache key list
	 */
	public List<String> getCacheKeyList() {
		List<String> ckl = new ArrayList<String>();

		if (WebApplet.get().getDatabaseResourceLoader() != null) {
			ckl.add(CKEY_RESOURCE);
		}

		if (WebApplet.get().getDatabaseTemplateLoader() != null) {
			ckl.add(CKEY_TEMPLATE);
		}
		
		return ckl;
	}

	/**
	 * @return SUCCESS
	 */
	public String index() {
		return SUCCESS;
	}
}