/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.aems.action.tools;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.List;

import nuts.core.lang.Strings;
import nuts.exts.struts2.actions.CommonAction;


/**
 */
public class AbstractSqlExecuteAction extends CommonAction {

	protected String commenter = "--";
	protected String delimiter = ";";
	protected boolean ignoreError = false;
	protected String sql;
	protected List<Result> results;
	protected int fetchLimit = 100;
	
	/**
	 */
	public AbstractSqlExecuteAction() {
	}

	/**
	 */
	public static class Result {
		private String sql;
		private int updateCount;
		private String error;
		private List<String[]> resultSet;
		
		/**
		 * @param sql sql
		 */
		public Result(String sql) {
			this.sql = sql;
		}
		/**
		 * @return the sql
		 */
		public String getSql() {
			return sql;
		}
		/**
		 * @param sql the sql to set
		 */
		public void setSql(String sql) {
			this.sql = sql;
		}
		/**
		 * @return the updateCount
		 */
		public int getUpdateCount() {
			return updateCount;
		}
		/**
		 * @param updateCount the updateCount to set
		 */
		public void setUpdateCount(int updateCount) {
			this.updateCount = updateCount;
		}
		/**
		 * @return the error
		 */
		public String getError() {
			return error;
		}
		/**
		 * @param error the error to set
		 */
		public void setError(String error) {
			this.error = error;
		}
		/**
		 * @return the resultSet
		 */
		public List<String[]> getResultSet() {
			return resultSet;
		}
		/**
		 * @param resultSet the resultSet to set
		 */
		public void setResultSet(List<String[]> resultSet) {
			this.resultSet = resultSet;
		}
	}

	/**
	 * @return the commenter
	 */
	public String getCommenter() {
		return commenter;
	}

	/**
	 * @param commenter the commenter to set
	 */
	public void setCommenter(String commenter) {
		this.commenter = commenter;
	}

	/**
	 * @return the delimiter
	 */
	public String getDelimiter() {
		return delimiter;
	}

	/**
	 * @param delimiter the delimiter to set
	 */
	public void setDelimiter(String delimiter) {
		this.delimiter = delimiter;
	}

	/**
	 * @return the ignoreError
	 */
	public boolean isIgnoreError() {
		return ignoreError;
	}

	/**
	 * @param ignoreError the ignoreError to set
	 */
	public void setIgnoreError(boolean ignoreError) {
		this.ignoreError = ignoreError;
	}

	/**
	 * @return the sql
	 */
	public String getSql() {
		return sql;
	}

	/**
	 * @param sql the sql to set
	 */
	public void setSql(String sql) {
		this.sql = Strings.stripToNull(sql);
	}

	/**
	 * @return the fetchLimit
	 */
	public int getFetchLimit() {
		return fetchLimit;
	}

	/**
	 * @param fetchLimit the fetchLimit to set
	 */
	public void setFetchLimit(int fetchLimit) {
		this.fetchLimit = fetchLimit;
	}

	/**
	 * @return the results
	 */
	public List<Result> getResults() {
		return results;
	}

	/**
	 * execute
	 * @return INPUT
	 * @throws Exception if an error occurs
	 */
	public String execute() throws Exception {
		return INPUT;
	}

	protected String removeComment(String sql) throws Exception {
		if (Strings.isNotEmpty(sql)) {
			BufferedReader br = new BufferedReader(new StringReader(sql));
	
			StringBuilder sb = new StringBuilder();
			String line;
			while ((line = br.readLine()) != null) {
				String lt = line.trim();
				if (lt.length() > 0 && !lt.startsWith(commenter)) {
					sb.append(line).append("\r\n");
				}
			}
			sql = sb.toString();
		}
		return sql;
	}
}
